 ; Ŀ
 ;   Getq: find all the variables in a lisp file and write them to a file  
 ;   with the same name and the extension ".var".                          
 ;   Copyright 1992, 2006 by Rocket Software Ltd.                          
 ;   Computers don't make mistakes...if you use Rocket Software.           
 ; 

 ; Ŀ
 ;   Wipeout: a subroutine.                                                
 ;   Convert the variable list to a string and write it to a file.         
 ; 
 (DEFUN WIPEOUT (brak / nnum nexx vars xfile)
  (if (> (length write) 0)
      (progn
           (grtext -2 "Compiling variable list")
           (setq nnum 0)
           (while (setq nexx (nth nnum write))
                  (setq nnum (1+ nnum))
                  (if vars
                      (setq vars (strcat vars " " nexx))
                      (setq vars nexx)))
           (if brak (setq vars (strcat vars (chr 41))))
           (setq xfile (open varfil "a"))        
           (write-line vars xfile)
           (close xfile)
           (setq write ()))))

 ; Ŀ
 ;   The main program.                                                     
 ; 
 (DEFUN C:GETQ (/ num varlen file1 gnu len ll ch ffile varfil txa lena lenn
                               varpa varend nextvar varlist write nexx vars)
  (grtext -1 " Rocket Software")
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq num 0)
  (setq varlen 0)
 ; Ŀ
 ;   Get a filename, add ".lsp" if no extension, make variable file name.  
 ; 
  (if ff
     (progn
          (setq file1 (getstring (strcat "\nFile to read <" ff ">: ")))
          (if (= file1 "") (setq file1 ff)))
     (setq file1 (getstring "\nFile to read: ")))
  (if file1 (setq ff file1))
 ; Ŀ
 ;   Ask whether to start a new variable list after each defun statement.  
 ; 
  (initget 0 "Yes No")
  (setq gnu (getkword "Repeat variables after Defun <Yes>: "))
  (if (or (null gnu) (= gnu "Yes"))
      (setq gnu T)
      (setq gnu ()))
 ; Ŀ
 ;   See if the filename needs to have ".lsp" added to the end, make the   
 ;   the variable name file name.                                          
 ; 
  (setq len (strlen file1))
  (setq ll 1)
  (while (< ll len)
         (if (= (substr file1 ll 1) ".")
             (setq ch T))
         (setq ll (1+ ll)))
  (if (null ch)
      (progn
           (setq varfil (strcat file1 ".var"))
           (setq file1 (strcat file1 ".lsp")))
      (progn
           (setq ll 1)
           (while (/= (substr file1 ll 1) ".")
                  (setq ll (1+ ll)))
           (setq varfil (strcat (substr file1 1 (1- ll)) ".var"))))
 ; Ŀ
 ;   Search the path for the file in case AutoCAD is looking in the wrong  
 ;   place.                                                                
 ; 
  (setq file1 (findfile file1))
 ; Ŀ
 ;   Open the file and save the Dos file handle.                           
 ; 
  (setq ffile (open file1 "r"))
 ; Ŀ
 ;   Read a line from the input file and make sure it isn't empty.         
 ; 
  (while (setq txa (read-line ffile))        ; read a line
         (setq num (1+ num))
         (grtext -2 (itoa num))
         (if (and (/= txa "") (/= txa " ") (/= txa "  ")
                  (/= (substr txa 1 1) ";") (/= (substr txa 1 2) " ;"))
             (progn                          ; ignore empty line
 ; Ŀ
 ;   Check to see if the line contains a "DEFUN C:" statement.             
 ; 
                  (while (= (substr txa 1 1) " ")
                         (setq txa (substr txa 2)))
                  (if (= (strcase (substr txa 1 6)) "(DEFUN")       ; balance )
                      (progn
                           (setq lenn 8)
                           (while (and (/= (substr txa lenn 1) " ")
                                       (/= (substr txa lenn 1) "(")); balance )
                                  (setq lenn (1+ lenn)))
                           (wipeout T)
                           (setq write (list (strcat (substr txa 1 lenn)
                                                     "(/")))       ; balance )
                           (if gnu (setq varlist ()))))
 ; Ŀ
 ;   Now search the line for "Setq"s and make a list the variable names.   
 ; 
                  (setq lena (- (strlen txa) 4))
                  (setq lenn 1)
                  (while (< lenn lena)
                         (if (= (strcase (substr txa lenn 4)) "SETQ")
                             (progn
                                  (setq varpa (+ lenn 5))
                                  (setq varend (+ lenn 6))
                                  (while (and (/= (substr txa varend 1) " ")
                                              (<= varend (strlen txa)))
                                         (setq varend (1+ varend)))
                                  (setq nextvar (substr txa varpa
                                                          (- varend varpa)))
                                  (if (and (not (member nextvar varlist))
                                           (/= nextvar ")"))     ; ( balancer
                                      (progn
                                           (if varlist
                                               (setq varlist (append varlist 
                                                               (list nextvar)))
                                               (setq varlist (list nextvar)))
                                           (if write
                                               (setq write (append write
                                                              (list nextvar)))
                                               (setq write (list nextvar)))
                                           (setq varlen (+ varlen 1 
                                                             (strlen nextvar)))
                                           (if (>= varlen 60)
                                               (progn
                                                    (setq varlen 0)
                                                    (wipeout ())))))))
                         (setq lenn (1+ lenn))))))
 ; Ŀ
 ;   Close file, make variable file.                                       
 ; 
  (close ffile)
  (wipeout T)
  (grtext -2 varfil)
  (grtext)
 (PRINC))